
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1002.C - Message 1002 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1002 messages.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Source\Archives\MSG1002.C_v  $
//   
//      Rev 1.17   08 Dec 1999 15:48:52   phungh
//   re-checking in to put under revision 1.17
//   
//      Rev 1.16   08 Dec 1999 15:35:16   phungh
//   Modify to display 1102 data only when
//   Flag1102 is TRUE
//   
//      Rev 1.15   09 Nov 1998 10:47:44   phungh
//   labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the 
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the "write to file"
//   code portion out of the interrupt handler
//   so that data is not missed because of time
//   spent too long in the interrupt handler
//   
//      Rev 1.4   Jul 09 1997 09:51:40   COLEJ
//   Multiple Changes...
//   
//      Rev 1.3   Feb 12 1997 16:05:16   COLEJ
//    
//   
//      Rev 1.2   Aug 26 1996 18:42:54   COLEJ
//    
//   
//      Rev 1.1   Aug 14 1996 09:23:30   COLEJ
//   Deleated UTCNSECS and adjusted othe fields.
//   Display GPSSECS vice GPS time.
//   
//   
//      Rev 1.0   13 May 1996 14:52:40   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////
 
#include <stdio.h>
#include <graph.h>
#include <math.h>

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"   
#include "util.h" 
#include "display.h"

tSHORT  NumTrkSats;
extern  tBOOL Flag1102; // For CN0 display

////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1002 message from the ZMsgBuf.
//      
void Dec1002(tMSGBUF *ZMsgBuf, tMSG1002 *Msg)
{  
   tSHORT i;

   for(i=0; i<GI_NUM_HW_CHAN; i++){ 
      GetBit(&ChnSumData[i].MeasUsed  , ZMsgBuf, 15+3*i, 0);  // 1=used       
      GetBit(&ChnSumData[i].EphAvail  , ZMsgBuf, 15+3*i, 1);  // 1=available  
      GetBit(&ChnSumData[i].MeasValid , ZMsgBuf, 15+3*i, 2);  // 1=valid
      GetBit(&ChnSumData[i].DGPSAvail , ZMsgBuf, 15+3*i, 3);  // 1=available
   }                                              
}                                      
                                     
////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac 1002 message in the ZMsgBuf. 
//
void Bld1002(tMSGBUF *ZMsgBuf, tMSG1002 *Msg)
{
   tSHORT i;

   // ack flags assumed preset

   PutShort  (0x81FF                       , ZMsgBuf, 1);         // message preamble
   PutShort  (1002                         , ZMsgBuf, 2);         // message number
   PutShort  (96                           , ZMsgBuf, 3);         // message length 
 //PutShort  (CheckSum(ZMsgBuf[0], 4)      , ZMsgBuf, 5);         // header check sum
 
   for(i=0; i<GI_NUM_HW_CHAN; i++){ 
      PutBit(ChnSumData[i].MeasUsed  , ZMsgBuf, 15+3*i, 0); // 1=used       
      PutBit(ChnSumData[i].EphAvail  , ZMsgBuf, 15+3*i, 1); // 1=available  
      PutBit(ChnSumData[i].MeasValid , ZMsgBuf, 15+3*i, 2); // 1=valid
      PutBit(ChnSumData[i].DGPSAvail , ZMsgBuf, 15+3*i, 3); // 1=available
   }                                             
     
 //PutShort  (CheckSum(ZMsgBuf, 6, 197)       , ZMsgBuf, 203);   // data check sum 
}

////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1002 message from the ZMsgBuf.
//      
void Show1002(tMSG1002 *Msg)
{  
   char    Buf[80] = "";
   char    *DayName[7] ={"SUN", "MON", "TUE", "WED", "THU", "FRI", "SAT"}; 
   char    DayOfWeek[5]; 
//   short   GPSHours, GPSMinutes, GPSSeconds;
   double  GPSTimeSeconds,GPSTimeNSeconds;
   unsigned long  tempsecs;
   unsigned short gpsprecision = 7;  // used to calculate precision field of gpssec output
   
   tSHORT  i;


   // convert values  
   
   // perform special processing for output
   NumTrkSats = 0;
   
   // time values  -  now done only in msg1032
//   GPSHours    = (short) (Msg->GPSTimeSeconds / 3600.f);
//   TimeTemp    = Msg->GPSTimeSeconds - GPSHours * 3600.f;
//   GPSMinutes  = (short) (TimeTemp  / 60.f);
//   TimeTemp    = TimeTemp - GPSMinutes * 60.f;
//   GPSSeconds  = (short) TimeTemp;

   // calculate gpssec field
   tempsecs = Msg->GPSTimeSeconds;
   while( tempsecs /= 10 ){ gpsprecision--; };
   // get rid of roundoff for nano seconds
   GPSTimeNSeconds = (double) ( Msg->GPSTimeNanoseconds / (unsigned long) pow( 10.0, (9.0 - (double) gpsprecision) ) );
   GPSTimeNSeconds *= pow( 10.0, (9.0 - (double) gpsprecision) );
   GPSTimeSeconds = Msg->GPSTimeSeconds + GPSTimeNSeconds / 1E+09;



   sprintf(DayOfWeek,"%s",
           DayName[(short)(Msg->GPSTimeSeconds / 86400)]);
//   sprintf(GPSHourMinSecNsec,"%3d:%02d:%02d.%03d",
//           GPSHours,GPSMinutes,GPSSeconds,
//           Msg->GPSTimeNanoseconds / 1000000);  

   sprintf(Buf,"%05d"  ,Msg->SequenceNumber        );ShowText(Buf,TIMR+ 6,TIMC+ 4);
   sprintf(Buf,"%05d"  ,Msg->MeasSequenceNumber    );ShowText(Buf,TIMR+ 6,TIMC+12);
   sprintf(Buf,"%4d "  ,Msg->GPSWeek               );ShowText(Buf,TIMR+ 4,TIMC+ 5);
   sprintf(Buf,"%9.*f" ,gpsprecision,GPSTimeSeconds);ShowText(Buf,TIMR+ 2,TIMC+ 8);
// sprintf(Buf,"%s"    ,GPSHourMinSecNsec          );ShowText(Buf,TIMR+ 3,TIMC+ 4);
   sprintf(Buf,"%09ld" ,Msg->GPSTimeNanoseconds    );ShowText(Buf,TIMR+ 3,TIMC+ 8);

   for(i=0; i<GI_NUM_HW_CHAN; i++){ 
   sprintf(Buf,"%2d"  ,i + 1                       );ShowText(Buf,CHNR+ i,CHNC   ); 
//HP   sprintf(Buf,"%2d"  ,Msg->ChanSum[i].PRN         );ShowText(Buf,CHNR+ i,CHNC+ 4);  

 //sprintf(Buf,"%2d"  ,Msg->ChanSum[i].ChanStatus  );ShowText(Buf,CHNR+ i,CHNC+ 9);
   if(Flag1102 == TRUE) { 
      sprintf(Buf,"%2d"  ,Msg->ChanSum[i].PRN);
      ShowText(Buf,CHNR+ i,CHNC+ 4);  
   	  sprintf(Buf,"%2d"  ,Msg->ChanSum[i].CN0);
   	  ShowText(Buf,CHNR+ i,CHNC+14);
   } 
 
   // special processing for output
   sprintf(Buf,"%1d" ,ChnSumData[i].MeasUsed ); ShowText(Buf,CHNR+ i,CHNC+ 8);      
   sprintf(Buf,"%1d" ,ChnSumData[i].EphAvail ); ShowText(Buf,CHNR+ i,CHNC+10);
   sprintf(Buf,"%1d" ,ChnSumData[i].MeasValid); ShowText(Buf,CHNR+ i,CHNC+ 9);
   sprintf(Buf,"%1d" ,ChnSumData[i].DGPSAvail); ShowText(Buf,CHNR+ i,CHNC+11); 
   
   // count the number of satellites in track, no check for unique yet
   if(ChnSumData[i].MeasValid){
      NumTrkSats++;
   }       
   }
   sprintf(Buf,"%2d/"   ,NumTrkSats          ); ShowText(Buf,DOPR- 1,DOPC+ 5);

}
